unit RgDemo;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls,
  Vcl.ExtCtrls, Vcl.Buttons;

type
  TForm1 = class(TForm)
    Log: TMemo;
    btLoadLbr: TButton;
    btLbrVersion: TButton;
    btLbrInit: TButton;
    btFindEndp: TButton;
    cmbListPorts: TComboBox;
    btInitRdr: TButton;
    btnSetMask: TButton;
    btnSetProf: TButton;
    btnStatus: TButton;
    btMfReadPlus: TButton;
    btMfRas: TBitBtn;
    btMfRats: TBitBtn;
    btMfAuthPlus: TBitBtn;
    edAesKey: TEdit;
    Label1: TLabel;
    btMfWritePlus: TButton;
    edMfdata: TEdit;
    Label2: TLabel;
    btSL0_to_SL1: TBitBtn;
    edAesTagr: TEdit;
    Label3: TLabel;
    btSL1_to_SL3: TBitBtn;
    btMfRstFld: TButton;
    Memo1: TMemo;
    BitBtn1: TBitBtn;
    btMfClAuth: TBitBtn;
    Label4: TLabel;
    EdClKey: TEdit;
    btClReadPlus: TButton;
    btMfWriteCl: TButton;
    Label5: TLabel;
    Edit2: TEdit;
    Memo2: TMemo;
    btRG_GetCard: TButton;
    procedure LogDblClick(Sender: TObject);
    procedure btLoadLbrClick(Sender: TObject);
    procedure btLbrVersionClick(Sender: TObject);
    procedure btLbrInitClick(Sender: TObject);
    procedure btFindEndpClick(Sender: TObject);
    procedure btInitRdrClick(Sender: TObject);
    procedure btnSetMaskClick(Sender: TObject);
    procedure btnSetProfClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnStatusClick(Sender: TObject);
    procedure btMfReadPlusClick(Sender: TObject);
    procedure btMfRasClick(Sender: TObject);
    procedure btMfRatsClick(Sender: TObject);
    procedure btMfAuthPlusClick(Sender: TObject);
    procedure btMfWritePlusClick(Sender: TObject);
    procedure btSL0_to_SL1Click(Sender: TObject);
    procedure btSL1_to_SL3Click(Sender: TObject);
    procedure btMfRstFldClick(Sender: TObject);
    procedure btMfClAuthClick(Sender: TObject);
    procedure btClReadPlusClick(Sender: TObject);
    procedure btMfWriteClClick(Sender: TObject);
    procedure btRG_GetCardClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses RgReaderApiDef, RgReaderApiType, RgReaderApi, RgUtil;
{$R *.dfm}

procedure TForm1.btClReadPlusClick(Sender: TObject);
var
  EndPoint: TPRG_ENDPOINT;
  DevAddress: uint8;
  block_data: Tblock_data;
  blockNum: uint16;
begin
  //     PLUS
  EndPoint.address := cmbListPorts.Text;
  EndPoint.ENDPOINT_TYPE := TRG_ENDPOINT_TYPE.ET_USBHID;
  DevAddress := 0; //  USB address=0
  blockNum := 1;
  if RG_MF_ReadBlock(@EndPoint, DevAddress, blockNum, 0, @block_data[0],
    length(block_data)) = 0 then
  begin
    Log.Lines.Add('RG_MF_ReadBlock ok');
    Log.Lines.Add(ArrayToHexString(@block_data[0], length(block_data)));
  end
  else
    Log.Lines.Add('RG_MF_ReadBlock ');
end;

procedure TForm1.btFindEndpClick(Sender: TObject);
var
  EndPointListHandle: THandle;
  Count: uint32;
  i: integer;
  EndpointInfo: TRG_ENDPOINT_INFO;
begin
  //     USB
  if RG_FindEndPoints(@EndPointListHandle, TRG_ENDPOINT_TYPE.ET_USBHID,
    @Count) = 0 then
    Log.Lines.Add('RG_FindEndPoints ')
  else
  begin
    Log.Lines.Add('RG_FindEndPoints ');
    exit;
  end;
  if Count = 0 then
  begin
    Log.Lines.Add('  ');
    exit;
  end;
  for i := 0 to Count - 1 do
  begin
    if RG_GetFoundEndPointInfo(EndPointListHandle, i, @EndpointInfo) = 0 then
    begin
      Log.Lines.Add('RG_GetFoundEndPointInfo ok');
      cmbListPorts.Items.Add(EndpointInfo.address);
    end
    else
      Log.Lines.Add('RG_GetFoundEndPointInfo ');
  end;
  if cmbListPorts.Items.Count > 0 then
    cmbListPorts.ItemIndex := 0;

  if RG_CloseResource(EndPointListHandle) = 0 then
    Log.Lines.Add('RG_CloseResource ok')
  else
    Log.Lines.Add('RG_CloseResource ');
end;

procedure TForm1.btInitRdrClick(Sender: TObject);
var
  EndPoint: TPRG_ENDPOINT;
  DevAddress: uint8;
begin
  //    
  EndPoint.address := cmbListPorts.Text;
  EndPoint.ENDPOINT_TYPE := TRG_ENDPOINT_TYPE.ET_USBHID;
  DevAddress := 0; //  USB address=0
  //     
  if RG_CloseDevice(@EndPoint, DevAddress) = 0 then
    Log.Lines.Add('RG_CloseDevice ok')
  else
    Log.Lines.Add('RG_CloseDevice ');

  if RG_InitDevice(@EndPoint, DevAddress) = 0 then
    Log.Lines.Add('RG_InitDevice ok')
  else
    Log.Lines.Add('RG_InitDevice ');
end;

procedure TForm1.btLbrInitClick(Sender: TObject);
begin
  //   
  if RG_InitializeLib = 0 then
    Log.Lines.Add(' ')
  else
    Log.Lines.Add(' ');
end;

procedure TForm1.btLbrVersionClick(Sender: TObject);
var
  Ver: cardinal;
begin
  //  
  Ver := RG_GetVersion;
  Log.Lines.Add(inttostr(Ver shr 16) + '.' + inttostr(Ver and $FFFF));
end;

procedure TForm1.btLoadLbrClick(Sender: TObject);
begin
  //  
  if RgLoadLibrary() then
    Log.Lines.Add(' ')
  else
    Log.Lines.Add('  ');
end;

procedure TForm1.btMfAuthPlusClick(Sender: TObject);
var
  EndPoint: TPRG_ENDPOINT;
  DevAddress: uint8;
  KeyBufAes: TRG_MIFARE_AES_KEY;
  sec: byte;
  blockNum: uint16;
begin
  //    Plus
  EndPoint.address := cmbListPorts.Text;
  EndPoint.ENDPOINT_TYPE := TRG_ENDPOINT_TYPE.ET_USBHID;
  DevAddress := 0; //  USB address=0

  FillChar(KeyBufAes, length(KeyBufAes), 0);
  HexStringToArray(edAesKey.Text, @KeyBufAes[0], length(KeyBufAes));
  sec := 0;

  blockNum := $4000 + sec * 2;
  if RG_Iso_Auth(@EndPoint, DevAddress, blockNum, @KeyBufAes[0],
    length(KeyBufAes)) = 0 then
    Log.Lines.Add('RG_Iso_Auth ok')
  else
    Log.Lines.Add('RG_Iso_Auth ');
end;

procedure TForm1.btMfClAuthClick(Sender: TObject);
var
  EndPoint: TPRG_ENDPOINT;
  DevAddress: uint8;
  KeyBufCl: TRG_MIFARE_KEY;
  blockNum: uint16;
begin
  //    Plus
  EndPoint.address := cmbListPorts.Text;
  EndPoint.ENDPOINT_TYPE := TRG_ENDPOINT_TYPE.ET_USBHID;
  DevAddress := 0; //  USB address=0

  FillChar(KeyBufCl, length(KeyBufCl), 0);
  HexStringToArray(EdClKey.Text, @KeyBufCl[0], length(KeyBufCl));

  blockNum := 1;
  if RG_MF_AuthorizeClassic(@EndPoint, DevAddress, blockNum, 0, @KeyBufCl[0]) = 0
  then
    Log.Lines.Add('RG_MF_AuthorizeClassic ok')
  else
    Log.Lines.Add('RG_MF_AuthorizeClassic ');
end;

procedure TForm1.btMfRasClick(Sender: TObject);
var
  EndPoint: TPRG_ENDPOINT;
  DevAddress: uint8;
  AtsBuf: TRespBuf;
  AtsSize: int32;
  Sak: uint16;
  Atqa: uint16;
  Uid: TRG_CARD_UID;
  Err: Tapi_error;
begin
  // RAS
  EndPoint.address := cmbListPorts.Text;
  EndPoint.ENDPOINT_TYPE := TRG_ENDPOINT_TYPE.ET_USBHID;
  DevAddress := 0; //  USB address=0
  Err := RG_Iso_Ras(@EndPoint, DevAddress, @Sak, @Atqa, @Uid[0], length(Uid));
  if Err = 0 then
    Log.Lines.Add('RG_Iso_Ras ok')
  else
  begin
    Log.Lines.Add('RG_Iso_Ras ');
    Log.Lines.Add(GetLasrErrorr(Err));
  end;
end;

procedure TForm1.btMfRatsClick(Sender: TObject);
var
  EndPoint: TPRG_ENDPOINT;
  DevAddress: uint8;
  AtsBuf: TRespBuf;
  AtsSize: int32;
  Err: Tapi_error;
begin
  // RATS
  EndPoint.address := cmbListPorts.Text;
  EndPoint.ENDPOINT_TYPE := TRG_ENDPOINT_TYPE.ET_USBHID;
  DevAddress := 0; //  USB address=0
  Err := RG_Iso_Rats(@EndPoint, DevAddress, @AtsBuf[0], length(AtsBuf),
    @AtsSize);
  if Err = 0 then
    Log.Lines.Add('RG_Iso_Rats ok')
  else
  begin
    Log.Lines.Add('RG_Iso_Rats ');
    Log.Lines.Add(GetLasrErrorr(Err));
  end;
end;

procedure TForm1.btMfReadPlusClick(Sender: TObject);
var
  EndPoint: TPRG_ENDPOINT;
  DevAddress: uint8;
  block_data: Tblock_data;
  blockNum: uint16;
begin
  //     PLUS
  EndPoint.address := cmbListPorts.Text;
  EndPoint.ENDPOINT_TYPE := TRG_ENDPOINT_TYPE.ET_USBHID;
  DevAddress := 0; //  USB address=0
  blockNum := $4000 + 1; // 1  0  
  if RG_MF_ReadBlock(@EndPoint, DevAddress, blockNum, 2, @block_data[0],
    length(block_data)) = 0 then
  begin
    Log.Lines.Add('RG_MF_ReadBlock ok');
    Log.Lines.Add(ArrayToHexString(@block_data[0], length(block_data)));
  end
  else
    Log.Lines.Add('RG_MF_ReadBlock ');
end;

procedure TForm1.btMfWriteClClick(Sender: TObject);
var
  EndPoint: TPRG_ENDPOINT;
  DevAddress: uint8;
  block_data: Tblock_data;
  blockNum: uint16;
begin
  //     PLUS
  EndPoint.address := cmbListPorts.Text;
  EndPoint.ENDPOINT_TYPE := TRG_ENDPOINT_TYPE.ET_USBHID;
  DevAddress := 0; //  USB address=0
  blockNum := 1;
  HexStringToArray(edMfdata.Text, @block_data[0], length(block_data));
  if RG_MF_WriteBlock(@EndPoint, DevAddress, blockNum, 0, @block_data[0],
    length(block_data)) = 0 then
    Log.Lines.Add('RG_MF_WriteBlock ok')
  else
    Log.Lines.Add('RG_MF_WriteBlock ');

end;

procedure TForm1.btMfWritePlusClick(Sender: TObject);
var
  EndPoint: TPRG_ENDPOINT;
  DevAddress: uint8;
  block_data: Tblock_data;
  blockNum: uint16;
begin
  //     PLUS
  EndPoint.address := cmbListPorts.Text;
  EndPoint.ENDPOINT_TYPE := TRG_ENDPOINT_TYPE.ET_USBHID;
  DevAddress := 0; //  USB address=0
  blockNum := $4000 + 1; // 1  0  
  HexStringToArray(edMfdata.Text, @block_data[0], length(block_data));
  if RG_MF_WriteBlock(@EndPoint, DevAddress, blockNum, 2, @block_data[0],
    length(block_data)) = 0 then
    Log.Lines.Add('RG_MF_WriteBlock ok')
  else
    Log.Lines.Add('RG_MF_WriteBlock ');
end;

procedure TForm1.btnSetMaskClick(Sender: TObject);
var
  EndPoint: TPRG_ENDPOINT;
  DevAddress: uint8;
begin
  //      RG_GetStatus
  //  TRG_CARD_FAMILY_CODE
  EndPoint.address := cmbListPorts.Text;
  EndPoint.ENDPOINT_TYPE := TRG_ENDPOINT_TYPE.ET_USBHID;
  DevAddress := 0; //  USB address=0
  if RG_SetCardsMask(@EndPoint, DevAddress, $FF) = 0 then
    Log.Lines.Add('RG_SetCardsMask ok')
  else
    Log.Lines.Add('RG_SetCardsMask ');
end;

procedure TForm1.btnSetProfClick(Sender: TObject);
var
  EndPoint: TPRG_ENDPOINT;
  DevAddress: uint8;
  profileNum: uint8;
  blockNum: uint8;
  CardAuthParams: TRG_CARD_AUTH_PARAMS;
begin
  //         RG_GetStatus
  EndPoint.address := cmbListPorts.Text;
  EndPoint.ENDPOINT_TYPE := TRG_ENDPOINT_TYPE.ET_USBHID;
  DevAddress := 0; //  USB address=0
  if RG_ClearProfiles(@EndPoint, DevAddress) = 0 then
    Log.Lines.Add('RG_ClearProfiles ok')
  else
    Log.Lines.Add('RG_ClearProfiles ');

  profileNum := 0;
  blockNum := 1;
  CardAuthParams.asscessFlags := 0;
  HexStringToArray('FFFFFFFFFFFF', @CardAuthParams.classicKey[0],
    length(CardAuthParams.classicKey));
  HexStringToArray('FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF',
    @CardAuthParams.plusKey[0], length(CardAuthParams.plusKey));
  if RG_WriteProfile(@EndPoint, DevAddress, profileNum, blockNum,
    @CardAuthParams) = 0 then
    Log.Lines.Add('RG_WriteProfile ok')
  else
    Log.Lines.Add('RG_WriteProfile ');
end;

procedure TForm1.btnStatusClick(Sender: TObject);
var
  EndPoint: TPRG_ENDPOINT;
  DevAddress: uint8;
  StatusType: TRG_STATUS_TYPE;
  PinStates: uint8;
  CardInfo: TRG_CARD_INFO;
  Memory: TRG_CARD_MEMORY;
  Err: Tapi_error;
begin
  //    
  EndPoint.address := cmbListPorts.Text;
  EndPoint.ENDPOINT_TYPE := TRG_ENDPOINT_TYPE.ET_USBHID;
  DevAddress := 0; //  USB address=0
  Err := RG_GetStatus(@EndPoint, DevAddress, @StatusType, @PinStates,
    @CardInfo, @Memory);
  if Err = 0 then
  begin
    Log.Lines.Add('RG_GetStatus ok');
    if StatusType = STE_NO_CARD then
      Log.Lines.Add(' ')
    else
    begin
      Log.Lines.Add('UID ' + CardUid2Code(CardInfo.cardUid));
      if StatusType = STE_CARD_AUTH then
        Log.Lines.Add('Data ' + ArrayToHexString(@Memory.block_data[0],
          length(Memory.block_data)));
    end;
  end
  else
  begin
    Log.Lines.Add('RG_GetStatus ');
    Log.Lines.Add(GetLasrErrorr(Err));
  end;
end;

procedure TForm1.btSL0_to_SL1Click(Sender: TObject);
var
  EndPoint: TPRG_ENDPOINT;
  DevAddress: uint8;
  req, resp: TRespBuf;
  RespSize: int32;
  blockNum: uint16;
  Err: Tapi_error;
begin
  //   PLUS SL0  SL1

  //  RAS     
  btMfRas.Click;
  Application.ProcessMessages;
  //  RATS     
  btMfRats.Click;
  Application.ProcessMessages;

  EndPoint.address := cmbListPorts.Text;
  EndPoint.ENDPOINT_TYPE := TRG_ENDPOINT_TYPE.ET_USBHID;
  DevAddress := 0; //  USB address=0
  FillChar(req, sizeof(req), 0);
  FillChar(resp, sizeof(resp), 0);
  req[0] := $A8;
  req[1] := $00;
  req[2] := $90;
  HexStringToArray(edAesTagr.Text, @req[3], 16);
  Err := RG_Iso_Exchange(@EndPoint, DevAddress, @req[0], 16 + 3, @resp[0],
    length(resp), @RespSize);
  if Err = 0 then
    Log.Lines.Add('RG_Iso_Exchange 9000 ok')
  else
  begin
    Log.Lines.Add('RG_Iso_Exchange 9000 ');
    Log.Lines.Add(GetLasrErrorr(Err));
  end;
  if not((RespSize > 0) and (resp[0] = $90)) then
  begin
    Log.Lines.Add('RG_Iso_Exchange RespSize 9000 ');
  end;
  Application.ProcessMessages;

  req[0] := $A8;
  req[1] := $01;
  req[2] := $90;
  if RG_Iso_Exchange(@EndPoint, DevAddress, @req[0], 16 + 3, @resp[0],
    length(resp), @RespSize) = 0 then
    Log.Lines.Add('RG_Iso_Exchange 9001 ok')
  else
    Log.Lines.Add('RG_Iso_Exchange 9001 ');
  if not((RespSize > 0) and (resp[0] = $90)) then
  begin
    Log.Lines.Add('RG_Iso_Exchange RespSize 9001 ');
  end;
  Application.ProcessMessages;

  // 9002  
  req[0] := $A8;
  req[1] := $03;
  req[2] := $90;
  if RG_Iso_Exchange(@EndPoint, DevAddress, @req[0], 16 + 3, @resp[0],
    length(resp), @RespSize) = 0 then
    Log.Lines.Add('RG_Iso_Exchange 9003 ok')
  else
    Log.Lines.Add('RG_Iso_Exchange 9003 ');
  if not((RespSize > 0) and (resp[0] = $90)) then
  begin
    Log.Lines.Add('RG_Iso_Exchange RespSize 9003 ');
  end;
  Application.ProcessMessages;

  req[0] := $A8;
  req[1] := $04;
  req[2] := $90;
  if RG_Iso_Exchange(@EndPoint, DevAddress, @req[0], 16 + 3, @resp[0],
    length(resp), @RespSize) = 0 then
    Log.Lines.Add('RG_Iso_Exchange 9004 ok')
  else
    Log.Lines.Add('RG_Iso_Exchange 9004 ');
  if not((RespSize > 0) and (resp[0] = $90)) then
  begin
    Log.Lines.Add('RG_Iso_Exchange RespSize 9004 ');
  end;
  Application.ProcessMessages;

  // AES     0 ,     
  //  
  blockNum := $4000 + 0 * 2;
  req[0] := $A8;
  req[1] := byte(blockNum);
  req[2] := byte(blockNum shr 8);
  if RG_Iso_Exchange(@EndPoint, DevAddress, @req[0], 16 + 3, @resp[0],
    length(resp), @RespSize) = 0 then
    Log.Lines.Add('RG_Iso_Exchange  ok')
  else
    Log.Lines.Add('RG_Iso_Exchange  ');
  if not((RespSize > 0) and (resp[0] = $90)) then
  begin
    Log.Lines.Add('RG_Iso_Exchange  ');
  end;
  Application.ProcessMessages;

  //  
  blockNum := blockNum + 1;
  req[0] := $A8;
  req[1] := byte(blockNum);
  req[2] := byte(blockNum shr 8);
  if RG_Iso_Exchange(@EndPoint, DevAddress, @req[0], 16 + 3, @resp[0],
    length(resp), @RespSize) = 0 then
    Log.Lines.Add('RG_Iso_Exchange  ok')
  else
    Log.Lines.Add('RG_Iso_Exchange  ');
  if not((RespSize > 0) and (resp[0] = $90)) then
  begin
    Log.Lines.Add('RG_Iso_Exchange  ');
  end;
  Application.ProcessMessages;

  req[0] := $AA;
  if RG_Iso_Exchange(@EndPoint, DevAddress, @req[0], 1, @resp[0], length(resp),
    @RespSize) = 0 then
    Log.Lines.Add('RG_Iso_Exchange $AA ok')
  else
    Log.Lines.Add('RG_Iso_Exchange $AA ');
  if not((RespSize > 0) and (resp[0] = $90)) then
  begin
    Log.Lines.Add('RG_Iso_Exchange RespSize $AA ');
  end;
  Application.ProcessMessages;

end;

procedure TForm1.btSL1_to_SL3Click(Sender: TObject);
var
  EndPoint: TPRG_ENDPOINT;
  DevAddress: uint8;
  KeyBufAes: TRG_MIFARE_AES_KEY;
  sec: byte;
  blockNum: uint16;
begin
  //   PLUS SL1  SL3
  //   btMfAuthPlus,    9003   e   9003   SL0  SL3

  //  RAS     
  btMfRas.Click;
  Application.ProcessMessages;
  //  RATS     
  btMfRats.Click;
  Application.ProcessMessages;

  EndPoint.address := cmbListPorts.Text;
  EndPoint.ENDPOINT_TYPE := TRG_ENDPOINT_TYPE.ET_USBHID;
  DevAddress := 0; //  USB address=0

  FillChar(KeyBufAes, length(KeyBufAes), 0);
  HexStringToArray(edAesTagr.Text, @KeyBufAes[0], length(KeyBufAes));

  blockNum := $9003;;
  if RG_Iso_Auth(@EndPoint, DevAddress, blockNum, @KeyBufAes[0],
    length(KeyBufAes)) = 0 then
    Log.Lines.Add('RG_Iso_Auth 9003 ok')
  else
    Log.Lines.Add('RG_Iso_Auth 9003 ');
end;

procedure TForm1.btMfRstFldClick(Sender: TObject);
var
  EndPoint: TPRG_ENDPOINT;
  DevAddress: uint8;
begin
  //   
  EndPoint.address := cmbListPorts.Text;
  EndPoint.ENDPOINT_TYPE := TRG_ENDPOINT_TYPE.ET_USBHID;
  DevAddress := 0; //  USB address=0
  if RG_ResetField(@EndPoint, DevAddress) = 0 then
    Log.Lines.Add('RG_ResetField ok')
  else
    Log.Lines.Add('RG_ResetField ');
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Log.Lines.Add
    ('!!!          ' +
    #13#10 + '    API,  ');
end;

procedure TForm1.LogDblClick(Sender: TObject);
begin
  Log.Lines.Clear;
end;

procedure TForm1.btRG_GetCardClick(Sender: TObject);
var
  EndPoint: TPRG_ENDPOINT;
  DevAddress: uint8;
  StatusType: TRG_STATUS_TYPE;
  Err: Tapi_error;
  Rg_SetBlock: TRg_SetBlock;
  RG_CARD_UID: TRG_CARD_UID;
  UidSize: int32;
begin
  //    
  // EndPoint.address := 'COM8';
  // EndPoint.ENDPOINT_TYPE := TRG_ENDPOINT_TYPE.ET_SERIAL;
  EndPoint.address := cmbListPorts.Text;
  EndPoint.ENDPOINT_TYPE := TRG_ENDPOINT_TYPE.ET_USBHID;
  DevAddress := 0; //  USB address=0
  Err := RG_GetCard(@EndPoint, DevAddress, @StatusType, @RG_CARD_UID[0],
    length(RG_CARD_UID), @UidSize);
  if Err = 0 then
  begin
    Log.Lines.Add('RG_GetCard ok');
    if StatusType = STE_NO_CARD then
      Log.Lines.Add(' ')
    else
    begin
      Log.Lines.Add('UID ' + CardUid2Code(RG_CARD_UID));
      // if StatusType = STE_CARD_AUTH then
      // Log.Lines.Add('Data ' + ArrayToHexString(@Memory.block_data[0],
      // length(Memory.block_data)));
    end;
  end
  else
  begin
    Log.Lines.Add('RG_GetCard ');
    Log.Lines.Add(GetLasrErrorr(Err));
  end;
  exit;
  Err := RG_UnlockSettigns(@EndPoint, DevAddress, 0);
  if Err = 0 then
  begin
    Log.Lines.Add('RG_UnlockSettigns ok')
  end
  else
  begin
    Log.Lines.Add('RG_UnlockSettigns ');
    Log.Lines.Add(GetLasrErrorr(Err));
  end;

  Err := RG_ReadSettingsBlock(@EndPoint, DevAddress,
    TRG_SETTINGS_BLOCK_TYPE.ESB_SETTINGS, 0, @Rg_SetBlock[0],
    length(Rg_SetBlock));
  if Err = 0 then
  begin
    Log.Lines.Add('RG_ReadSettingsBlock ok')
  end
  else
  begin
    Log.Lines.Add('RG_ReadSettingsBlock ');
    Log.Lines.Add(GetLasrErrorr(Err));
  end;

  Err := RG_UnlockSettigns(@EndPoint, DevAddress, 0);
  if Err = 0 then
  begin
    Log.Lines.Add('RG_UnlockSettigns ok')
  end
  else
  begin
    Log.Lines.Add('RG_UnlockSettigns ');
    Log.Lines.Add(GetLasrErrorr(Err));
  end;

  sleep(500);
  Rg_SetBlock[2] := 32;
  // Rg_SetBlock[3] := 1;
  Err := RG_WriteSettingsBlock(@EndPoint, DevAddress,
    TRG_SETTINGS_BLOCK_TYPE.ESB_SETTINGS, 0, @Rg_SetBlock[0],
    length(Rg_SetBlock));
  if Err = 0 then
  begin
    Log.Lines.Add('RG_WriteSettingsBlock ok')
  end
  else
  begin
    Log.Lines.Add('RG_WriteSettingsBlock ');
    Log.Lines.Add(GetLasrErrorr(Err));
  end;
  sleep(500);
  Err := RG_CommitSettings(@EndPoint, DevAddress, 0);
  if Err = 0 then
  begin
    Log.Lines.Add('RG_CommitSettings ok')
  end
  else
  begin
    Log.Lines.Add('RG_CommitSettings ');
    Log.Lines.Add(GetLasrErrorr(Err));
  end;

end;

end.
